/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.ui.wizard;

import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.ui.wizard.LinkMappingPanel;
import com.paterva.maltego.graph.table.ui.wizard.MappingPanel;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.util.ui.dialog.ValidatingController;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.Exceptions;

public class LinkMappingController
extends ValidatingController<MappingPanel>
implements WizardDescriptor.ValidatingPanel {
    public LinkMappingController() {
        this.setName("Map Columns to Links");
    }

    protected MappingPanel createComponent() {
        return new LinkMappingPanel();
    }

    protected void readSettings(WizardDescriptor settings) {
        TabularGraph tabularGraph = (TabularGraph)settings.getProperty("graphTable");
        List files = (List)this.getDescriptor().getProperty("files");
        try {
            MappingPanel comp = (MappingPanel)this.component();
            comp.setTabularGraphAndSampleFile(tabularGraph, (File)files.get(0));
            if (comp instanceof LinkMappingPanel) {
                LinkMappingPanel mapingPanel = (LinkMappingPanel)comp;
                mapingPanel.updateHtoComboBox();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    protected void storeSettings(WizardDescriptor settings) {
    }

    public void validate() throws WizardValidationException {
        String error = null;
        TabularGraph tabularGraph = (TabularGraph)this.getDescriptor().getProperty("graphTable");
        error = this.checkAllPropertiesMapped(tabularGraph);
        if (error != null) {
            throw new WizardValidationException((JComponent)this.component(), error, error);
        }
    }

    private String checkAllPropertiesMapped(TabularGraph tabularGraph) {
        List links = tabularGraph.getLinks();
        int linkNum = 0;
        for (TabularGraphLink link : links) {
            ++linkNum;
            for (int column : link.getColumns()) {
                PropertyDescriptor pd = link.getProperty(column);
                if (pd != null) continue;
                String columnName = tabularGraph.getColumnNames()[column];
                ((MappingPanel)this.component()).select(link.getColumns());
                return this.getUnmappedPropertyError(link, linkNum, columnName);
            }
        }
        return null;
    }

    private String getUnmappedPropertyError(TabularGraphLink link, int linkNum, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(link.getIndex());
        sb.append("(");
        sb.append(linkNum);
        sb.append(")->");
        sb.append(columnName);
        sb.append(" is not mapped to a property. All columns added to a link must be mapped.");
        return sb.toString();
    }
}

