/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.certificates.rest;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;

public class CountingOutputStream
extends FilterOutputStream {
    private final Consumer<Long> bytesWritten;
    private long transferred;

    public CountingOutputStream(OutputStream out, Consumer<Long> bytesWrittenCallback) {
        super(out);
        this.bytesWritten = bytesWrittenCallback;
        this.transferred = 0L;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.transferred += (long)len;
        this.bytesWritten.accept(this.transferred);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.transferred;
        this.bytesWritten.accept(this.transferred);
    }
}

