/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.finder.wizard;

import com.paterva.maltego.seeds.api.HubSeedDescriptor;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.dialog.ChangeEventPropagator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class ChooseSeedsControl
extends JPanel {
    private final ChangeEventPropagator _changeSupport = new ChangeEventPropagator((Object)this);
    private final Map<HubSeedDescriptor, JCheckBox> publicSeedsMap = new HashMap<HubSeedDescriptor, JCheckBox>();
    private JLabel _localInfoLabel;
    private JCheckBox _localSeedCheckBox;
    private JTextField _localServerTextField;
    private JLabel _localServerUrlLabel;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextArea noteTextArea;

    public ChooseSeedsControl() {
        this.initComponents();
        this._localSeedCheckBox.addChangeListener((ChangeListener)this._changeSupport);
        this._localServerTextField.getDocument().addDocumentListener((DocumentListener)this._changeSupport);
        this.updateLocalSeedState();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._changeSupport.addChangeListener(changeListener);
    }

    public void setSeedDiscoveryFailed(boolean maltegoIdOffline) {
        this.jPanel1.removeAll();
        JPanel warningPanel = new JPanel(new BorderLayout());
        warningPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel lbl = new JLabel(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.warningLabel.text"));
        if (maltegoIdOffline) {
            lbl.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/transform/finder/resources/Info.png")));
        } else {
            lbl.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/transform/finder/resources/Alert.png")));
            lbl.setForeground(Color.red.darker());
        }
        lbl.setFont(lbl.getFont().deriveFont(lbl.getFont().getStyle() | 1));
        warningPanel.add((Component)lbl, "North");
        JTextArea textArea = new JTextArea(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.warningTextArea.text"));
        if (maltegoIdOffline) {
            textArea.setText("The public hub list can't be shown due the Maltego ID: Offline Activation option that was chosen.");
        }
        textArea.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        textArea.setOpaque(false);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setDisabledTextColor(UIManager.getLookAndFeelDefaults().getColor("Label.darculaMod.label-desired-fg"));
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setRows(4);
        warningPanel.add((Component)textArea, "Center");
        this.jPanel1.add((Component)warningPanel, "Center");
    }

    public void setPublicSeeds(List<HubSeedDescriptor> descriptorList) {
        if (descriptorList.isEmpty()) {
            this.jPanel1.removeAll();
            this.jLabel2.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.infoNoPublicSeedsLabel.text"));
            this.jLabel2.setFont(this.jLabel2.getFont().deriveFont(this.jLabel2.getFont().getStyle() | 1, 13.0f));
            JPanel infoPanel = new JPanel(new BorderLayout());
            infoPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JTextArea textArea = new JTextArea(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.infoNoPublicSeedsTextArea.text"));
            textArea.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            textArea.setOpaque(false);
            textArea.setEditable(false);
            textArea.setEnabled(false);
            textArea.setDisabledTextColor(UIManager.getLookAndFeelDefaults().getColor("Label.darculaMod.label-desired-fg"));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setRows(4);
            infoPanel.add((Component)textArea, "Center");
            this.jPanel1.add((Component)infoPanel, "North");
        } else {
            this.jPanel1.removeAll();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.removeAll();
            JComponent jPanel1Content = panel;
            for (HubSeedDescriptor seed : descriptorList) {
                if (panel.getComponentCount() == 5) {
                    JScrollPane sp = new JScrollPane(panel);
                    Dimension size = panel.getPreferredSize();
                    size.width = (int)((double)size.width + sp.getVerticalScrollBar().getPreferredSize().getWidth());
                    sp.setPreferredSize(size);
                    sp.setMinimumSize(size);
                    sp.setMaximumSize(size);
                    jPanel1Content = sp;
                }
                JComponent hubSeedComponent = this.createHubSeedComponent(seed);
                panel.add(hubSeedComponent);
            }
            this.jPanel1.add((Component)jPanel1Content, "Center");
        }
    }

    public Map<HubSeedDescriptor, Boolean> getPublicSeedSelection() {
        HashMap<HubSeedDescriptor, Boolean> publicSeedSelection = new HashMap<HubSeedDescriptor, Boolean>();
        this.publicSeedsMap.entrySet().stream().forEach(e -> publicSeedSelection.put((HubSeedDescriptor)e.getKey(), ((JCheckBox)e.getValue()).isSelected()));
        return publicSeedSelection;
    }

    public void adjustViewForFreeUser(boolean isFreeUser) {
        if (isFreeUser) {
            this.noteTextArea.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.noteTextArea.text_freeUser"));
        } else {
            this.noteTextArea.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.noteTextArea.text"));
        }
        boolean localSeedVisible = !isFreeUser;
        this._localSeedCheckBox.setVisible(localSeedVisible);
        this._localInfoLabel.setVisible(localSeedVisible);
        this._localServerUrlLabel.setVisible(localSeedVisible);
        this._localServerTextField.setVisible(localSeedVisible);
        if (!localSeedVisible) {
            this.setLocalSeedEnabled(false);
        }
    }

    public void setLocalSeedEnabled(boolean booleanValue) {
        this._localSeedCheckBox.setSelected(booleanValue);
        this.updateLocalSeedState();
    }

    public boolean isLocalSeedEnabled() {
        return this._localSeedCheckBox.isSelected();
    }

    public void setLocalSeedUrl(String localSeedUrl) {
        this._localServerTextField.setText(localSeedUrl);
    }

    public String getLocalSeedUrl() {
        return this._localServerTextField.getText().trim();
    }

    private JComponent createHubSeedComponent(HubSeedDescriptor seed) {
        JCheckBox cb = new JCheckBox(seed.getDisplayName(), true);
        this.publicSeedsMap.put(seed, cb);
        JLabel lbl = new JLabel(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/transform/finder/resources/Help.png")));
        String hubSeedTooltip = this.createHubSeedTooltip(seed);
        lbl.setToolTipText(hubSeedTooltip);
        JPanel component = new JPanel(new FlowLayout(0, 0, 3));
        component.add(cb);
        component.add(Box.createHorizontalStrut(6));
        component.add(lbl);
        return component;
    }

    private String createHubSeedTooltip(HubSeedDescriptor seed) {
        StringBuilder tooltipSb = new StringBuilder("<html>");
        String providerName = seed.getProvider().getName();
        if (!StringUtilities.isNullOrEmpty((String)providerName)) {
            tooltipSb.append("<p>").append("by ").append(providerName).append("</p>");
        }
        tooltipSb.append("<p>").append(seed.getDescription()).append("</p>");
        return tooltipSb.toString();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this._localServerUrlLabel = new JLabel();
        this.noteTextArea = new JTextArea();
        this._localServerTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this._localSeedCheckBox = new JCheckBox();
        this._localInfoLabel = new JLabel();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.jLabel2.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.jLabel2.text_1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this._localServerUrlLabel.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl._localServerUrlLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 60, 6, 6);
        this.add((Component)this._localServerUrlLabel, gridBagConstraints);
        this.noteTextArea.setEditable(false);
        this.noteTextArea.setBackground(this.getBackground());
        this.noteTextArea.setFont(new JLabel().getFont());
        this.noteTextArea.setLineWrap(true);
        this.noteTextArea.setRows(1);
        this.noteTextArea.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl.noteTextArea.text"));
        this.noteTextArea.setWrapStyleWord(true);
        this.noteTextArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.noteTextArea.setFocusable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)this.noteTextArea, gridBagConstraints);
        this._localServerTextField.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl._localServerTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 6, 20);
        this.add((Component)this._localServerTextField, gridBagConstraints);
        this.jPanel1.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 20, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new BorderLayout(6, 0));
        this._localSeedCheckBox.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl._localSeedCheckBox.text"));
        this._localSeedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChooseSeedsControl.this._localSeedCheckBoxActionPerformed(evt);
            }
        });
        this.jPanel2.add((Component)this._localSeedCheckBox, "Center");
        this._localInfoLabel.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/transform/finder/resources/Help.png")));
        this._localInfoLabel.setText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl._localInfoLabel.text"));
        this._localInfoLabel.setToolTipText(NbBundle.getMessage(ChooseSeedsControl.class, (String)"ChooseSeedsControl._localInfoLabel.toolTipText"));
        this.jPanel2.add((Component)this._localInfoLabel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 20, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void _localSeedCheckBoxActionPerformed(ActionEvent evt) {
        this.updateLocalSeedState();
    }

    private void updateLocalSeedState() {
        this._localServerTextField.setEnabled(this._localSeedCheckBox.isSelected());
        this._localServerUrlLabel.setEnabled(this._localSeedCheckBox.isSelected());
    }
}

