/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.hfsexplorer.Util;

public class ResourceHeader
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 16;
    private final byte[] dataOffset = new byte[4];
    private final byte[] mapOffset = new byte[4];
    private final byte[] dataLength = new byte[4];
    private final byte[] mapLength = new byte[4];

    public ResourceHeader(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.dataOffset, 0, 4);
        System.arraycopy(data, offset + 4, this.mapOffset, 0, 4);
        System.arraycopy(data, offset + 8, this.dataLength, 0, 4);
        System.arraycopy(data, offset + 12, this.mapLength, 0, 4);
    }

    public static int length() {
        return 16;
    }

    public int getDataOffset() {
        return Util.readIntBE(this.dataOffset);
    }

    public int getMapOffset() {
        return Util.readIntBE(this.mapOffset);
    }

    public int getDataLength() {
        return Util.readIntBE(this.dataLength);
    }

    public int getMapLength() {
        return Util.readIntBE(this.mapLength);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " dataOffset: " + this.getDataOffset());
        ps.println(prefix + " mapOffset: " + this.getMapOffset());
        ps.println(prefix + " dataLength: " + this.getDataLength());
        ps.println(prefix + " mapLength: " + this.getMapLength());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ResourceHeader:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[ResourceHeader.length()];
        int offset = 0;
        System.arraycopy(this.dataOffset, 0, result, offset, this.dataOffset.length);
        System.arraycopy(this.mapOffset, 0, result, offset += this.dataOffset.length, this.mapOffset.length);
        System.arraycopy(this.dataLength, 0, result, offset += this.mapOffset.length, this.dataLength.length);
        System.arraycopy(this.mapLength, 0, result, offset += this.dataLength.length, this.mapLength.length);
        offset += this.mapLength.length;
        return result;
    }

    public int size() {
        return ResourceHeader.length();
    }
}

