/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

public class HashUtils {
    public static int getV6SignatureSaltSizeInBytes(int n) {
        switch (n) {
            case 8: 
            case 11: 
            case 12: 
            case 313: {
                return 16;
            }
            case 9: {
                return 24;
            }
            case 10: 
            case 14: 
            case 315: {
                return 32;
            }
        }
        throw new IllegalArgumentException("Salt size not specified for Hash Algorithm with ID " + n);
    }

    public boolean saltSizeMatchesSpec(int n, int n2) {
        try {
            return n2 == HashUtils.getV6SignatureSaltSizeInBytes(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

